#ifndef __AX12_H
#define __AX12_H

/******************************************************************************
 *
 * Dynamixel AX-12 Servo Control Library
 * Filename: ax12.h
 *
 * THIS IS THE HEADER FILE
 *
 * Instructions: Include this file in your main program source code, and define
 * the following header directives, depending on which serial line is used to
 * interface with the AX12 data line.
 *****************************************************************************/

//Servo motor control table addresses
//EEPROM
#define CT_ID				0x03
#define CT_BAUD_RATE		0x04
#define CT_RETURN_DELAY		0x05
#define CT_CW_ANGLELIMIT_L	0x06
#define CT_CW_ANGLELIMIT_H	0x07
#define CT_CCW_ANGLELIMIT_L	0x08
#define CT_CCW_ANGLELIMIT_H	0x09
#define CT_MAX_TORQUE_L		0x0E
#define CT_MAX_TORQUE_H		0x0F
#define CT_STATUS_RETURN	0x10
#define CT_ALARM_LED		0x11
//RAM
#define CT_TORQUE_ENABLE	0x18
#define CT_GOAL_POSITION_L	0x1E
#define CT_GOAL_POSITION_H	0x1F
#define CT_MOVING_SPEED_L	0x20
#define CT_MOVING_SPEED_H	0x21
#define CT_PRESENT_POS_L	0x24
#define CT_PRESENT_POS_H	0x25
#define CT_PRESENT_SPEED_L	0x26
#define CT_PRESENT_SPEED_H	0x27
#define CT_PRESENT_LOAD_L	0x28
#define CT_PRESENT_LOAD_H	0x29
#define CT_PRESENT_VOLTAGE	0x2A
#define CT_REGISTERED_INST	0x2C
#define CT_MOVING			0x2E

//Servo Motor Instruction Set
#define I_PING				0x01
#define I_READ_DATA			0x02
#define	I_WRITE_DATA		0x03
#define I_REG_WRITE			0x04
#define I_ACTION			0x05
#define I_RESET				0x06
#define I_SYNC_WRITE		0x07

//Function prototypes for all of the function in the library
//Please refer to the ax12.c file for instruction on how to use these functions
void AX_SetId(char, char);
void AX_Ping(char);
char* AX_RxPacket(void);
char AX_RxByte(void);
char AX_ByteRdy();
void AX_TxPacket(char, char, char*, char);
void AX_SendByte(char);
void AX_SetupUSART(void);

#endif